local wezterm = require 'wezterm'
local act = wezterm.action

local config = {}

if wezterm.config_builder then config = wezterm.config_builder() end

config.quit_when_all_windows_are_closed = false
config.scrollback_lines = 50000
config.enable_scroll_bar = true
config.audible_bell = "Disabled"



-- Visuals

config.font = wezterm.font_with_fallback {
    {
        family = '0xProto',
        weight = 'Regular', -- https://wezfurlong.org/wezterm/config/lua/wezterm/font.html
        harfbuzz_features = { -- https://wezfurlong.org/wezterm/config/font-shaping.html
            'calt=0',
            'clig=0',
            'liga=0'
        }
    },
    {
        family = "Apple Color Emoji",
        weight = "Regular",
        stretch = "Normal",
        style = "Normal"
    },
    'Noto Color Emoji'
}

config.font_rules = {

    {
        intensity = 'Bold',
        italic = false,
        font = wezterm.font {
            family = '0xProto',
            weight = "Bold",
        },
    },

    {
        intensity = 'Normal',
        italic = true,
        font = wezterm.font {
            family = '0xProto',
            style = "Italic",
            weight = "Regular",
        },
    },

    {
        intensity = 'Bold',
        italic = true,
        font = wezterm.font {
            family = '0xProto',
            style = "Italic",
            weight = 'Bold',
        },
    }

}

config.font_size = 14
config.line_height = 1.0

config.window_frame = {
    font = wezterm.font {family = 'Iosevka Aile', weight = 700},
    font_size = 14.0,
    active_titlebar_bg = '#eeeeee',
    inactive_titlebar_bg = '#ffffff'
}

config.use_fancy_tab_bar = true


-- Colors

local atom_one_light = wezterm.color.get_builtin_schemes()['AtomOneLight']
local color_scheme = wezterm.color.get_builtin_schemes()['AtomOneLight']

color_scheme.copy_mode_active_highlight_bg = { Color = '#e80da2' }
color_scheme.copy_mode_active_highlight_fg = { Color = '#ffffff' }
color_scheme.copy_mode_inactive_highlight_bg = { Color = '#eac7df' }
color_scheme.copy_mode_inactive_highlight_fg = { Color = '#000000' }
color_scheme.selection_fg = '#ffffff'
color_scheme.selection_bg = '#e80da2'
color_scheme.cursor_fg = '#ffffff'
color_scheme.cursor_bg = '#e80da2'

config.color_schemes = {
    ['AtomOneLight'] = atom_one_light,
    ['mjaschen'] = color_scheme,
}
config.color_scheme = 'mjaschen'

config.colors = {
    tab_bar = {
        active_tab = {bg_color = '#ffffff', fg_color = '#e80da2'},
        inactive_tab = {bg_color = '#cccccc', fg_color = '#444444'},
        inactive_tab_hover = {bg_color = '#eeeeee', fg_color = '#222222'},
        new_tab = {bg_color = '#cccccc', fg_color = '#111111'},
        new_tab_hover = {bg_color = '#eeeeee', fg_color = '#111111'},
        inactive_tab_edge = '#575757'
    }
}



-- Keyboard

config.keys = {

    {
        -- Make Option-Left equivalent to Alt-b which many line editors
        -- interpret as backward-word
        key = 'LeftArrow',
        mods = 'OPT',
        action = act.SendString '\x1bb'
    }, {
        -- Make Option-Right equivalent to Alt-f; forward-word
        key = 'RightArrow',
        mods = 'OPT',
        action = act.SendString '\x1bf'
    }, {
        -- Split panes (right/left) with ⌘D
        key = 'd',
        mods = 'SUPER',
        action = act.SplitHorizontal {domain = 'CurrentPaneDomain'}
    }, {
        -- Split panes (top/bottom) with ⌘⇧D
        key = 'd',
        mods = 'SUPER|SHIFT',
        action = act.SplitVertical {domain = 'CurrentPaneDomain'}
    }, {
        -- Change to next pane with ⌘]
        key = ']',
        mods = 'SUPER',
        action = act.ActivatePaneDirection('Next')
    }, {
        -- Change to previous pane with ⌘[
        key = '[',
        mods = 'SUPER',
        action = act.ActivatePaneDirection('Prev')
    }, {
        -- Move Tab to the right with ⌘⇧-RightArrow
        key = 'RightArrow',
        mods = 'SUPER|SHIFT',
        action = act.MoveTabRelative(1)
    }, {
        -- Move Tab to the left with ⌘⇧-LeftArrow
        key = 'LeftArrow',
        mods = 'SUPER|SHIFT',
        action = act.MoveTabRelative(-1)
    }, {
        -- Clears the scrollback and viewport, and then sends CTRL-L to ask the
        -- shell to redraw its prompt
        key = 'k',
        mods = 'SUPER',
        action = act.Multiple {
            act.ClearScrollback 'ScrollbackAndViewport',
            act.SendKey {key = 'L', mods = 'CTRL'}
        }
    }, {
        -- CMD-t open new tab in home directory
        -- (default behavior: open new tab in current directory)
        key = 't',
        mods = 'CMD',
        action = wezterm.action.SpawnCommandInNewTab {cwd = wezterm.home_dir}
    }, {
        -- Shift-Ctrl-Alt-k moves pane divider up
        key = 'k',
        mods = 'SHIFT|CTRL|ALT',
        action = act.AdjustPaneSize {"Up", 3}
    }, {
        -- Shift-Ctrl-Alt-j moves pane divider down
        key = 'j',
        mods = 'SHIFT|CTRL|ALT',
        action = act.AdjustPaneSize {"Down", 3}
    }, {
        -- Shift-Ctrl-Alt-h moves pane divider left
        key = 'h',
        mods = 'SHIFT|CTRL|ALT',
        action = act.AdjustPaneSize {"Left", 3}
    }, {
        -- Shift-Ctrl-Alt-l moves pane divider right
        key = 'l',
        mods = 'SHIFT|CTRL|ALT',
        action = act.AdjustPaneSize {"Right", 3}
    }, {
        -- Shift-Ctrl-Alt-z toggles zoom for current pane
        key = 'z',
        mods = 'SHIFT|CTRL|ALT',
        action = act.TogglePaneZoomState
    }

}

return config
